var reminderFox_QAcalendarOpened = false;


function popupOk(element) {
	var popup = reminderFox_findParentById( element, "oe-date-picker-popup", "oe-date-picker-popup-end" );
	popup.hidePopup();
}

function popupClosedQA(element) {	 
	// we'll calculate the difference between now and the selected date
	// and set the snooze to that number of minutes
	var currentDate = new Date();
	currentDate.setSeconds(0);
	currentDate.setMilliseconds(0);
	var currentDateTime = currentDate.getTime();
	
	var selectedDate = oeDatePicker.gSelectedDate;
	selectedDate.setSeconds(0);
	selectedDate.setMilliseconds(0);
	var selectedTime = selectedDate.getTime();
	
	var time = currentDateTime;
	if ( selectedTime > currentDateTime ) {
		var timeDiff = selectedTime - currentDateTime;
		var minutesDiff = timeDiff / 1000 / 60;
		var snoozeTimeList = document.getElementById("reminderFox-alertTime");	// quick alarm
		
		if ( snoozeTimeList == null ) {
			snoozeTimeList = document.getElementById("reminderFox-snoozeTime");	 // alarm
		}
		
		var snoozeTimeInt = Math.round( parseInt(minutesDiff));
		
		var timeUnitsList = document.getElementById('reminderFox-alertTimeUnits');			
		if (  reminderFox_mod( snoozeTimeInt , (60 * 24) ) == 0 ) { 
			// days
			snoozeTimeList.label =( snoozeTimeInt / (60*24) );
			timeUnitsList.selectedIndex = 2;			
		}
		else if (  reminderFox_mod( snoozeTimeInt , 60 ) == 0 ) { 
			// hours
			snoozeTimeList.label = (snoozeTimeInt / 60);	
			timeUnitsList.selectedIndex = 1;
		}
		else {
			// minutes
			snoozeTimeList.label = snoozeTimeInt;
			
			timeUnitsList.selectedIndex = 0;
		}
		reminderFox_snoozeTimeChanged();
	}
	else { 
		if ( selectedDate.getHours() > 0 || selectedDate.getMinutes() > 0 ) { // if any time was set other than default
			alert( reminderFox_getBundle().getString( "rf.add.time.button.calendar.date.select.invalid" ) );
		}
	}
}

function reminderfox_showCalendarQA() {
	if ( !reminderFox_QAcalendarOpened ) {
		var timeList = document.getElementById("reminderFox-timeList");	
		timeList.label =  timeList.firstChild.childNodes[0].getAttribute("label");

		oeDatePicker.resizeCalendar();  
		var reminderDate =  new Date();
		reminderDate.setHours(0);
		reminderDate.setMinutes(0);
		reminderDate.setSeconds(0);
		oeDatePicker.onpopupshowing(reminderDate, true, true);	
		reminderFox_QAcalendarOpened = true;	
	}
}

function loadAlarmOptions() {
		var alarmText = null;		
		var snoozeTime = null;		
		var alertGroup = document.getElementById('alertGroup');			
		var snoozeGroup = document.getElementById('snoozeGroup');	
		var alertButtonGroup = document.getElementById('alertButtonGroup');	
		
		var desc = document.getElementById("newAlarmText");
		// set alert time to first non-zero time 
		var alertTimesList = document.getElementById('reminderFox-alertTime');			
		var snoozeTimeList = document.getElementById('reminderFox-snoozeTime');	
		
		// otherwise, this is the initial window used for input
		snoozeGroup.setAttribute( "hidden", true);			
		alertGroup.removeAttribute( "hidden");
		desc.focus();
		
		var notesText = document.getElementById("notesText");	
		var notesToggleButton = document.getElementById("notesToggle");	
			
//		if ( reminderFoxEvent.notes != null ) {
//			notesText.setAttribute("hidden", "false");	
//			notesToggleButton.setAttribute( "checked", true );
//			notesText.value = reminderFoxEvent.notes;
//			notesToggleButton.setAttribute("tooltiptext", reminderFoxBundle.getString("rf.options.notes.tooltip.hide"));	
//		}
//		else {
			notesText.setAttribute("hidden", "true");	
			notesToggleButton.removeAttribute( "checked" );	
			notesToggleButton.setAttribute("tooltiptext", reminderFoxBundle.getString("rf.options.notes.tooltip.show"));	
		//}	
			
		reminderFox_updateSnoozeTimeDate();		
}


function getTimeString( date ) {
	var timeString;
	try {
			var hours = date.getHours();
			var AMorPM;
				
			var use24HourTime;
			try {
				use24HourTime = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_USE_24_HOUR_TIME);
			} catch(e) {
			}				
			if (  use24HourTime ) {
				AMorPM = "";
				if ( hours < 10 ) {
					hours = "0" + hours;
				}
			}
			else {
				AMorPM  =reminderFox_getBundle().getString("rf.add.time.PM");
				if ( AMorPM != "" ) {
					if ( hours < 12 ) {
						AMorPM = reminderFox_getBundle().getString("rf.add.time.AM");
					}
					if ( hours == 0 ) {
						hours = 12;
					}
					if ( hours >= 13 ) {
						hours = hours -12;
					}	
				}	
			}
		
			var minutes = date.getMinutes();
			if ( minutes < 10 ) {
				minutes = "0" + minutes;
			}
							
			timeString = hours + reminderFox_getBundle().getString("rf.add.time.delimiter") + minutes;
			if ( AMorPM != "" ) {
				timeString = timeString + " " + AMorPM;		
			}
		}
		catch ( e ) { 
		}
		return timeString;
}


function setAlarm() {
		var desc = document.getElementById("newAlarmText");
		var alertTimesList = document.getElementById("reminderFox-alertTime");	
		var snoozeTimeList = document.getElementById('reminderFox-snoozeTime');	
				
		var snoozeTime;
		var timeUnitsList;
		snoozeTime = alertTimesList.label;
		timeUnitsList = document.getElementById('reminderFox-alertTimeUnits');		
		
		if ( reminderFox_isInteger( snoozeTime ) ) {						
			if ( timeUnitsList != null ) { 
				var timeSelected = timeUnitsList.selectedIndex;
				if ( timeSelected == 1 ) {
					snoozeTime = snoozeTime * 60;
				}
				else if ( timeSelected == 2 ) {
					snoozeTime = snoozeTime * 60 * 24;
				}	
			}					
			
			var windowEnumerator =  reminderFox_getWindowEnumerator();
			if (windowEnumerator.hasMoreElements()) {
				var notesText = document.getElementById("notesText");
				var notes =notesText.value;
				if ( notes != null ) {
					notes = reminderFox_trim( notes );	
					notes = notes.replace(new RegExp(/\n/g),"\\n");
				}	
				
				var oldestWindow = windowEnumerator.getNext();				
				oldestWindow.setTimeout('reminderFox_showQuickAlarm("'+desc.value+'","'+snoozeTime+'","'+notes+'")', snoozeTime*60000);
			

				//var oldestWindow = windowEnumerator.getNext();				
				//oldestWindow.setTimeout('reminderFox_showQuickAlarm("'+desc.value+'","'+snoozeTime+'","'+notes+'")', snoozeTime*60000);
						
						
				//var val = desc.value;
				//oldestWindow.setTimeout(function(){ 
				//	var windowEnumerator =  reminderFox_getWindowEnumerator();
				//	if (windowEnumerator.hasMoreElements()) {
				//		var oldestWindow = windowEnumerator.getNext();	
				//		oldestWindow.reminderFox_showQuickAlarm(val, snoozeTime, notes);
				//	}
				//	else {
				//		alert( "FAILED!" );
				//	}
				//}, snoozeTime*60000);

		
				reminderFox_updateQuickAlarms( desc.value, snoozeTime, notes );				
			}		
		}	
		
		close();						
}

function reminderFox_updateQuickAlarms( quickAlarmText, snoozeTime, notesText ) {	
	var currentTime = new Date().getTime();
	currentTime = currentTime + (snoozeTime*60000);
	
	var newQuickAlarm = new ReminderFoxQuickAlarm( quickAlarmText, notesText, currentTime,  snoozeTime );
	
	reminderFox_updateQuickAlarm( newQuickAlarm );
}


function playAlarmSound() {
	// play a sound for notification (if the user elects to)
	try {
		var playSound = true;
		try {
			playSound = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_ALARM_SOUND);
		}
		catch ( e) {
		}
		if ( playSound ) {
			reminderFox_playSound();
	  	} // end if		
	}
	catch ( e ) {
	}
}

function reminderFox_snoozeTimeChanged() {
	document.getElementById("snoozeButton").setAttribute( "default", true );
	document.getElementById("okButton").setAttribute( "default", false );
	
	reminderFox_updateSnoozeTimeDate();
}


function reminderFox_updateSnoozeTimeDate() {
		var snoozeTimeList2 = null;
		var timeUnitsList2 = null;
		var snoozeUntilText = null;
		snoozeTimeList2 = document.getElementById("reminderFox-alertTime");	
		timeUnitsList2 = document.getElementById('reminderFox-alertTimeUnits');	
		snoozeUntilText = document.getElementById("alarmAtTime");
		var snoozeTime2 = snoozeTimeList2.label;
		if ( reminderFox_isInteger( snoozeTime2 ) ) {
			if ( timeUnitsList2 != null ) { 
				var timeSelected2 = timeUnitsList2.selectedIndex;
				if ( timeSelected2 == 1 ) {
					snoozeTime2 = snoozeTime2 * 60;
				}
				else if ( timeSelected2== 2 ) {
					snoozeTime2 = snoozeTime2 * 60 * 24;
				}	
			}				
			
			var currentTimeDate = new Date();
			var currentTime2 = currentTimeDate.getTime();
			var alarmTime2 = currentTime2 + (snoozeTime2*60000);		
			var snoozeDate2 = new Date();
			snoozeDate2.setTime( alarmTime2 );
			
			var snoozeString = "";
			if ( snoozeDate2.getMonth() != currentTimeDate.getMonth() ||
				snoozeDate2.getDate() != currentTimeDate.getDate() ) {
				var dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
				snoozeString=  reminderFox_getDateVariable( null , snoozeDate2, dateVariableString ) + ", ";
			}
			snoozeString += reminderFox_mail_getTimeString(snoozeDate2);
			snoozeUntilText.setAttribute( "value", snoozeString);
		}
}

function reminderFox_getDateVariableString(reminder, date )  {
	var dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
	return reminderFox_getDateVariable( reminder, date, dateVariableString );
}

function reminderFox_closeAlarm() {	
	window.close();
}